package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.Tarea;
import com.ejie.ab04b.model.TareaAperturas;
import com.ejie.ab04b.model.TramiteAperturas;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TareaAperturasDaoImpl generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class TareaAperturasDaoImpl implements TareaAperturasDao {

	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT = "SELECT t1.ID_TAREA_063 IDTAREA063, t1.MAILBOX_TASK_ID_063 MAILBOXTASKID063, t1.TIPO_TAREA_063 TIPOTAREA063, t1.ESTADO_063 ESTADO063, t1.FECHA_INI_063 FECHAINI063, t1.FECHA_FIN_063 FECHAFIN063, t1.USUARIO_063 USUARIO063, t1.ID_TRAMITE_063 IDTRAMITE063 FROM AB0463S00 t1 ";

	private static final Logger logger = LoggerFactory
			.getLogger(TareaAperturasDaoImpl.class);
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TareaAperturas> rwMap = new RowMapper<TareaAperturas>() {
		public TareaAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new TareaAperturas(resultSet.getLong("IDTAREA063"),
					resultSet.getString("MAILBOXTASKID063"),
					new Tarea(resultSet.getLong("TIPOTAREA063")),
					resultSet.getLong("ESTADO063"),
					resultSet.getTimestamp("FECHAINI063"),
					resultSet.getTimestamp("FECHAFIN063"),
					resultSet.getString("USUARIO063"),
					new TramiteAperturas(resultSet.getLong("IDTRAMITE063")));
		}
	};

	private RowMapper<TareaAperturas> rwMapPK = new RowMapper<TareaAperturas>() {
		public TareaAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new TareaAperturas(resultSet.getLong("IDTAREA063"));
		}
	};

	/**
	 * Gets the jdbc template.
	 * 
	 * JdbcTemplate
	 *
	 * @return the jdbc template
	 */
	public JdbcTemplate getJdbcTemplate() {
		return this.jdbcTemplate;
	}

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 *
	 * @param dataSource
	 *            the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the TareaAperturas table.
	 * 
	 * tareaAperturas TareaAperturas TareaAperturas
	 *
	 * @param tareaAperturas
	 *            the tarea aperturas
	 * @return the tarea aperturas
	 */
	public TareaAperturas add(TareaAperturas tareaAperturas) {
		String query = "INSERT INTO AB0463S00 (ID_TAREA_063, ID_TRAMITE_063, MAILBOX_TASK_ID_063, TIPO_TAREA_063, ESTADO_063, FECHA_INI_063, FECHA_FIN_063, USUARIO_063) VALUES (?,?,?,?,?,?,?,?)";

		// Obtiene el trámite relacionado
		Long getTramiteAperturasIdTramite062Aux = null;
		if (tareaAperturas.getTramiteAperturas() != null && tareaAperturas
				.getTramiteAperturas().getIdTramite062() != null) {
			getTramiteAperturasIdTramite062Aux = tareaAperturas
					.getTramiteAperturas().getIdTramite062();
		}

		// Obtenemos la secuencia
		tareaAperturas.setIdTarea063(
				Secuencias.TAREA_APERTURAS.getNextLong(this.jdbcTemplate));

		this.jdbcTemplate.update(query, tareaAperturas.getIdTarea063(),
				getTramiteAperturasIdTramite062Aux,
				tareaAperturas.getMailboxTaskId063(),
				tareaAperturas.getTipoTarea().getIdTarea090(),
				tareaAperturas.getEstado063(), tareaAperturas.getFechaIni063(),
				tareaAperturas.getFechaFin063(),
				tareaAperturas.getUsuario063());
		return tareaAperturas;
	}

	/**
	 * Updates a single row in the TareaAperturas table.
	 * 
	 * tareaAperturas TareaAperturas TareaAperturas
	 *
	 * @param tareaAperturas
	 *            the tarea aperturas
	 * @return the tarea aperturas
	 */
	public TareaAperturas update(TareaAperturas tareaAperturas) {
		String query = "UPDATE AB0463S00 SET ID_TRAMITE_063=?, MAILBOX_TASK_ID_063=?, TIPO_TAREA_063=?, ESTADO_063=?, FECHA_INI_063=?, FECHA_FIN_063=?, USUARIO_063=? WHERE ID_TAREA_063=?";
		Object getTramiteAperturasIdTramite062Aux = null;
		if (tareaAperturas.getTramiteAperturas() != null && tareaAperturas
				.getTramiteAperturas().getIdTramite062() != null) {
			getTramiteAperturasIdTramite062Aux = tareaAperturas
					.getTramiteAperturas().getIdTramite062();
		}
		this.jdbcTemplate.update(query, getTramiteAperturasIdTramite062Aux,
				tareaAperturas.getMailboxTaskId063(),
				tareaAperturas.getTipoTarea().getIdTarea090(),
				tareaAperturas.getEstado063(), tareaAperturas.getFechaIni063(),
				tareaAperturas.getFechaFin063(), tareaAperturas.getUsuario063(),
				tareaAperturas.getIdTarea063());
		return tareaAperturas;
	}

	/**
	 * Updates a single row in the Expedientes table.
	 * 
	 * tarea TareaAperturas TareaAperturas
	 *
	 * @param tarea
	 *            the tarea
	 * @return the tarea aperturas
	 */
	public TareaAperturas updateFilled(TareaAperturas tarea) {
		StringBuilder query = new StringBuilder("UPDATE AB0463S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (tarea != null) {

			if (tarea.getUsuario063() != null) {
				queryFields.append(", USUARIO_063 = ? ");
				params.add(tarea.getUsuario063());
			}
			if (tarea.getFechaFin063() != null) {
				queryFields.append(", FECHA_FIN_063 = ? ");
				params.add(tarea.getFechaFin063());
			}
			if (tarea.getEstado063() != null) {
				queryFields.append(", ESTADO_063 = ? ");
				params.add(tarea.getEstado063());
			}

			if (queryFields.length() > 0) {
				queryFields.deleteCharAt(0);
			}
		}

		query.append(queryFields);
		query.append(" WHERE ID_TAREA_063 = ?");

		params.add(tarea.getIdTarea063());

		logger.info(" updateFilled :=> ");
		logger.info("UPDATE AB0463S00 SET USUARIO_063 =" + tarea.getUsuario063()
				+ ", FECHA_FIN_063 =" + tarea.getFechaFin063()
				+ ",ESTADO_063 = " + tarea.getEstado063()
				+ " WHERE ID_TAREA_063 =" + tarea.getIdTarea063());

		this.jdbcTemplate.update(query.toString(), params.toArray());
		return tarea;
	}

	/**
	 * Finds a single row in the TareaAperturas table.
	 * 
	 * tareaAperturas TareaAperturas TareaAperturas
	 *
	 * @param tareaAperturas
	 *            the tarea aperturas
	 * @return the tarea aperturas
	 */
	@Transactional(readOnly = true)
	public TareaAperturas find(TareaAperturas tareaAperturas) {
		StringBuilder query = new StringBuilder(
				TareaAperturasDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TAREA_063 = ? ");

		List<TareaAperturas> tareaAperturasList = this.jdbcTemplate.query(
				query.toString(), this.rwMap, tareaAperturas.getIdTarea063());
		return (TareaAperturas) DataAccessUtils
				.uniqueResult(tareaAperturasList);
	}

	/**
	 * Finds a single row in the TareaAperturas table.
	 * 
	 * mailboxTaskId String TareaAperturas
	 *
	 * @param mailboxTaskId
	 *            the mailbox task id
	 * @return the tarea aperturas
	 */
	@Transactional(readOnly = true)
	public TareaAperturas findByMailboxTaskId(String mailboxTaskId) {
		StringBuilder query = new StringBuilder(
				TareaAperturasDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.MAILBOX_TASK_ID_063 = ? ");

		List<TareaAperturas> tareaAperturasList = this.jdbcTemplate
				.query(query.toString(), this.rwMap, mailboxTaskId);
		return (TareaAperturas) DataAccessUtils
				.uniqueResult(tareaAperturasList);
	}

	/**
	 * Removes a single row in the TareaAperturas table.
	 * 
	 * tareaAperturas TareaAperturas
	 *
	 * @param tareaAperturas
	 *            the tarea aperturas
	 */
	public void remove(TareaAperturas tareaAperturas) {
		String query = "DELETE FROM AB0463S00 WHERE ID_TAREA_063=?";
		this.jdbcTemplate.update(query, tareaAperturas.getIdTarea063());
	}

	/**
	 * Finds a list of rows in the TareaAperturas table.
	 * 
	 * tareaAperturas TareaAperturas jqGridRequestDto JQGridRequestDto List
	 * <TareaAperturas>
	 *
	 * @param tareaAperturas
	 *            the tarea aperturas
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TareaAperturas> findAll(TareaAperturas tareaAperturas,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				TareaAperturasDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tareaAperturas);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<TareaAperturas>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the TareaAperturas table using like.
	 * 
	 * tareaAperturas TareaAperturas jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean List<TareaAperturas>
	 *
	 * @param tareaAperturas
	 *            the tarea aperturas
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TareaAperturas> findAllLike(TareaAperturas tareaAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				TareaAperturasDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TAREA_063 = ? ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tareaAperturas,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<TareaAperturas>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the TareaAperturas table.
	 * 
	 * tareaAperturas TareaAperturas Long
	 *
	 * @param tareaAperturas
	 *            the tarea aperturas
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TareaAperturas tareaAperturas) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0463S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tareaAperturas);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the TareaAperturas table using like.
	 * 
	 * tareaAperturas TareaAperturas startsWith Boolean Long
	 *
	 * @param tareaAperturas
	 *            the tarea aperturas
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(TareaAperturas tareaAperturas,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0463S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tareaAperturas,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of TareaAperturas selected for rup_table.
	 * 
	 * tareaAperturas TareaAperturas jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean List<TableRowDto<TareaAperturas>>
	 *
	 * @param tareaAperturas
	 *            the tarea aperturas
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<TareaAperturas>> reorderSelection(
			TareaAperturas tareaAperturas, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				TareaAperturasDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TAREA_063 = ? ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tareaAperturas,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, TareaAperturas.class, filterParamList,
				"ID_TAREA_063");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<TareaAperturas>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams TareaAperturas searchParams TareaAperturas jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<TareaAperturas>>
	 *
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<TareaAperturas>> search(TareaAperturas filterParams,
			TareaAperturas searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				TareaAperturasDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TAREA_063 = ? ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, TareaAperturas.class, filterParamList,
				searchSQL, searchParamList, from_alias, "ID_TAREA_063");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<TareaAperturas>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TareaAperturas entity.
	 * 
	 * tareaAperturas TareaAperturas Bean with the criteria values to filter by.
	 * Map created with two keys key query stores the sql query syntax key
	 * params stores the parameter values to be used in the condition sentence.
	 *
	 * @param tareaAperturas
	 *            the tarea aperturas
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TareaAperturas tareaAperturas) {

		StringBuilder where = new StringBuilder(
				TareaAperturasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tareaAperturas != null && tareaAperturas.getIdTarea063() != null) {
			where.append(" AND t1.ID_TAREA_063 = ?");
			params.add(tareaAperturas.getIdTarea063());
		}
		if (tareaAperturas != null
				&& tareaAperturas.getTramiteAperturas() != null
				&& tareaAperturas.getTramiteAperturas()
						.getIdTramite062() != null) {
			where.append(" AND t1.ID_TRAMITE_063 = ?");
			params.add(tareaAperturas.getTramiteAperturas().getIdTramite062());
		}
		if (tareaAperturas != null
				&& tareaAperturas.getMailboxTaskId063() != null) {
			where.append(" AND t1.MAILBOX_TASK_ID_063 = ?");
			params.add(tareaAperturas.getMailboxTaskId063());
		}
		if (tareaAperturas != null && tareaAperturas.getTipoTarea() != null
				&& tareaAperturas.getTipoTarea().getIdTarea090() != null) {
			where.append(" AND t1.TIPO_TAREA_063 = ?");
			params.add(tareaAperturas.getTipoTarea().getIdTarea090());
		}
		if (tareaAperturas != null && tareaAperturas.getEstado063() != null) {
			where.append(" AND t1.ESTADO_063 = ?");
			params.add(tareaAperturas.getEstado063());
		}
		if (tareaAperturas != null && tareaAperturas.getFechaIni063() != null) {
			where.append(" AND t1.FECHA_INI_063 = ?");
			params.add(tareaAperturas.getFechaIni063());
		}
		if (tareaAperturas != null && tareaAperturas.getFechaFin063() != null) {
			where.append(" AND t1.FECHA_FIN_063 = ?");
			params.add(tareaAperturas.getFechaFin063());
		}
		if (tareaAperturas != null && tareaAperturas.getUsuario063() != null) {
			where.append(" AND t1.USUARIO_063 = ?");
			params.add(tareaAperturas.getUsuario063());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TareaAperturas entity.
	 * 
	 * tareaAperturas TareaAperturas Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 *
	 * @param tareaAperturas
	 *            the tarea aperturas
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(TareaAperturas tareaAperturas,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				TareaAperturasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tareaAperturas != null && tareaAperturas.getIdTarea063() != null) {
			where.append(" AND t1.ID_TAREA_063 = ?");
			params.add(tareaAperturas.getIdTarea063());
		}
		if (tareaAperturas != null
				&& tareaAperturas.getTramiteAperturas() != null
				&& tareaAperturas.getTramiteAperturas()
						.getIdTramite062() != null) {
			where.append(" AND t1.ID_TRAMITE_063 = ?");
			params.add(tareaAperturas.getTramiteAperturas().getIdTramite062());
		}
		if (tareaAperturas != null
				&& tareaAperturas.getMailboxTaskId063() != null) {
			where.append(
					" AND UPPER(t1.MAILBOX_TASK_ID_063) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tareaAperturas.getMailboxTaskId063().toUpperCase()
						+ "%");
			} else {
				params.add(
						"%" + tareaAperturas.getMailboxTaskId063().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.MAILBOX_TASK_ID_063 IS NOT NULL");
		}
		if (tareaAperturas != null && tareaAperturas.getTipoTarea() != null
				&& tareaAperturas.getTipoTarea().getIdTarea090() != null) {
			where.append(" AND t1.TIPO_TAREA_063 = ?");
			params.add(tareaAperturas.getTipoTarea().getIdTarea090());
		}
		if (tareaAperturas != null && tareaAperturas.getEstado063() != null) {
			where.append(" AND t1.ESTADO_063 = ?");
			params.add(tareaAperturas.getEstado063());
		}
		if (tareaAperturas != null && tareaAperturas.getFechaIni063() != null) {
			where.append(" AND t1.FECHA_INI_063 = ?");
			params.add(tareaAperturas.getFechaIni063());
		}
		if (tareaAperturas != null && tareaAperturas.getFechaFin063() != null) {
			where.append(" AND t1.FECHA_FIN_063 = ?");
			params.add(tareaAperturas.getFechaFin063());
		}
		if (tareaAperturas != null && tareaAperturas.getUsuario063() != null) {
			where.append(" AND UPPER(t1.USUARIO_063) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tareaAperturas.getUsuario063().toUpperCase() + "%");
			} else {
				params.add("%" + tareaAperturas.getUsuario063().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.USUARIO_063 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
